import requests
import re
import sys
from time import sleep
from datetime import datetime

# HTTP代理设置
PROXY_CONFIG = {
    'http': 'http://localhost:1080',
    'https': 'http://localhost:1080'
}

# 用于存储可用的代理配置
ACTIVE_PROXY = None

def test_proxy(proxy_config, test_url='https://www.baidu.com', timeout=1):
    """
    测试代理是否可用
    返回True表示代理可用，False表示代理不可用
    """
    try:
        response = requests.get(test_url, proxies=proxy_config, timeout=timeout)
        return response.status_code == 200
    except Exception as e:
        print(f"代理测试失败: {e}")
        return False

# 初始化时测试代理是否可用
ACTIVE_PROXY=None
#ACTIVE_PROXY = PROXY_CONFIG if test_proxy(PROXY_CONFIG) else None


def get_sh_index_tencent():
    """
    使用腾讯财经接口获取上证指数
    """
    try:
        # 腾讯财经股票接口
        url = "https://qt.gtimg.cn/q=sh000001"
        
        headers = {
            'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
        }
        
        # 根据代理测试结果决定是否使用代理
        response = requests.get(url, headers=headers, proxies=ACTIVE_PROXY, timeout=10)
        response.encoding = 'gbk'  # 腾讯接口返回编码为GBK
        
        if response.status_code == 200:
            data_text = response.text
            # 解析数据格式：v_sh000001="1~上证指数~000001~3223.56~3220.55~3220.98~1234567890~1234567~12345678~9.99~1.23~..."
            pattern = r'v_sh000001="(.*)"'
            match = re.search(pattern, data_text)
            
            if match:
                data_str = match.group(1)
                data_fields = data_str.split('~')
                
                # 解析各个字段
                index_info = {
                    '名称': data_fields[1],
                    '代码': data_fields[2],
                    '当前点数': float(data_fields[3]),
                    '昨收': float(data_fields[4]),
                    '今开': float(data_fields[5]),
                    '成交量': int(data_fields[6]),
                    '成交额': int(data_fields[7]),
                    '涨跌额': float(data_fields[31]),
                    '涨跌幅': f"{float(data_fields[32])}",
                    '最高': float(data_fields[33]),
                    '最低': float(data_fields[34]),
                    '时间': data_fields[30]
                }
                
                return index_info
            else:
                print("未找到指数数据")
                return None
        else:
            print(f"请求失败，状态码: {response.status_code}")
            return None
            
    except Exception as e:
        print(f"获取上证指数数据失败: {e}")
        return None
def get_stock_price_qq(stock_code):
    """
    通过腾讯财经接口获取股票数据
    """
    # 构造URL，上海股票前缀为sh，深圳为sz
    if stock_code.startswith('6'):
        symbol = f"sh{stock_code}"
    else:
        symbol = f"sz{stock_code}"
    
    url = f"https://qt.gtimg.cn/q={symbol}"
    
    try:
        # 根据代理测试结果决定是否使用代理
        response = requests.get(url, proxies=ACTIVE_PROXY)
        response.encoding = 'gbk'
        data = response.text
        # 数据格式：v_sz000001="51~平安银行~000001~17.52~17.30~17.30~392789~215677~177112~17.52~1430~17.51~1927~17.50~1345~17.49~2245~17.48~2270~17.53~1365~17.54~2435~17.55~3925~17.56~4984~17.57~2021-03-12 15:00:00~0.22~1.27~17.70~16.98~17.52/392789/6832781424~392789~68328~1.80~20.28~~17.70~16.98~2.12~684.06~684.06~4.13~19.05~15.23~1.07~26529~17.30~0.00~0.00~~~0.00~0.00~0.00~";
        if not data:
            return None
        
        data_list = data.split('~')
        if len(data_list) < 40:
            return None
        
        stock_info = {
            '代码': data_list[2],
            '名称': data_list[1],
            '当前价': float(data_list[3]),
            '昨收': float(data_list[4]),
            '开盘价': float(data_list[5]),
            '成交量': int(data_list[6]),
            '成交额': float(data_list[37]),  # 单位：万
            '买一价': float(data_list[9]),
            '买一量': int(data_list[10]),
            '买二价': float(data_list[11]),
            '买二量': int(data_list[12]),
            '买三价': float(data_list[13]),
            '买三量': int(data_list[14]),
            '买四价': float(data_list[15]),
            '买四量': int(data_list[16]),
            '买五价': float(data_list[17]),
            '买五量': int(data_list[18]),
            '卖一价': float(data_list[19]),
            '卖一量': int(data_list[20]),
            '卖二价': float(data_list[21]),
            '卖二量': int(data_list[22]),
            '卖三价': float(data_list[23]),
            '卖三量': int(data_list[24]),
            '卖四价': float(data_list[25]),
            '卖四量': int(data_list[26]),
            '卖五价': float(data_list[27]),
            '卖五量': int(data_list[28]),
            '时间': data_list[30],
            '涨跌额': float(data_list[31]),
            '涨跌幅': float(data_list[32]),
            '最高': float(data_list[33]),
            '最低': float(data_list[34])
        }
        return stock_info
    except Exception as e:
        print(f"从腾讯获取股票数据时出错: {e}")
        return None

def print_stock(id):
    stock_info = get_stock_price_qq(id)
    if stock_info:
        return f"{stock_info['名称']} {stock_info['当前价']}  {stock_info['涨跌幅']}"
        #隐蔽模式
        #return f"{stock_info['当前价']}  {stock_info['涨跌幅']}"
    else:
        return "获取失败"
# 

        
def print_in_place(lineNumber, text):
    """
    在控制台的指定行号处原地刷新文本
    lineNumber: 行号（从1开始计数）
    text: 要显示的文本
    """
    # 使用ANSI转义序列：\033[<line>;<col>H 移动光标到指定位置
    # 先定位到指定行的开头，然后打印文本，最后清除该行剩余部分
    print(f'\033[{lineNumber};1H{text}\033[K', end='', flush=True)

def print_stock_list(stock_list):
    while 1:
        current_time = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
        print_in_place(1, current_time)
        for i, stock in enumerate(stock_list, 1):
            print_in_place(i+1, f"{print_stock(stock)}")
        sleep(5)

def main():
    stock_list = ['688256', '300502', '688795']
    print_stock_list(stock_list)
def read_from_file_and_print(file_path):
    with open(file_path, 'r') as file:
        lines = file.readlines()
    stock_list = [line.strip() for line in lines]
    print_stock_list(stock_list)
if __name__ == "__main__":
    # 先打印一些初始内容作为参考行
    filename=sys.argv[1]
    read_from_file_and_print(filename)    
