import cv2  
  
# 加载Haar级联分类器模型  

face_cascade_path = cv2.data.haarcascades + 'haarcascade_frontalface_default.xml'
face_cascade = cv2.CascadeClassifier(face_cascade_path)  
  
# 读取图像  
img = cv2.imread('./1.jpeg')  
  
# 转换为灰度图像，因为Haar级联分类器需要灰度图像  
gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)  
  
# 检测人脸  
faces = face_cascade.detectMultiScale(gray, 1.3, 5)  
  
# 在图像上画出检测到的人脸  
for (x,y,w,h) in faces:  
    cv2.rectangle(img,(x,y),(x+w,y+h),(255,0,0),2)  
  
# 显示图像  
cv2.imshow('img',img)  
cv2.waitKey(0)  
cv2.destroyAllWindows()