
import time,os,sys
from flask import Flask, jsonify, request  
from flask import render_template


current_dir=os.path.dirname(os.path.realpath(sys.argv[0])).replace('\\','/') 
temp_dir=current_dir+'/temp'
static_dir=current_dir+'/main'



app = Flask(__name__,static_folder=static_dir,template_folder = static_dir,static_url_path="")

app.config['JSON_AS_ASCII'] = False  # 禁止中文转义


'''
{
    "userName" :"admin",
    "password": "123456"
}
'''


def GetAPort():
    start_port=9999
  
    return str(start_port)



def ExtractFilePath(DirPath):
    DirPath=DirPath.strip()
    DirPath = DirPath.replace("\\","/")
    index=DirPath.rfind("/")
    if index>=0:
        return DirPath[:DirPath.rfind("/")] 
    return ''

def ExtractFileName(DirPath):
    DirPath=DirPath.strip()
    DirPath = DirPath.replace("\\","/")
    return DirPath[DirPath.rfind("/")+1:]

def isEmptyFolder(path):
    if os.path.isdir(path):
        if not os.listdir(path):
            return 1
    return 0
    

@app.route('/')
def index():
    return render_template('index.html') 


def find_dict_ref(thelist,name):
    #thelist is the dict
    for  i in  range(len(thelist['children'])):
        if thelist['children'][i]['label']==name:
            return thelist['children'][i]
    return None
def add_treelist_data(root_dict,fullpath,type):
   
    path=fullpath.replace(current_dir+'/files/','')
    values=path.split('/')
    child_ref=None
    parent_ref=root_dict
   
    for x in values:

        child_ref=find_dict_ref(parent_ref,x)
        if not child_ref:
            name=x.replace('.txt','')
            parent_ref['children'].append({'label':name,'children':[],'type':0,'path': ExtractFilePath(fullpath)})
            child_ref=parent_ref['children'][-1]
        parent_ref=child_ref

    parent_ref['type']=type
    parent_ref['path']=fullpath
    
   
    return 1


def getfile_fullpath(thename,rootpath=''):
    if not thename.endswith('.txt'):
      
        return ''
    if rootpath=='':
        rootpath=current_dir+'/files'
    
    rootpath=rootpath.replace('\\','/')
   
    dir_list=os.listdir(rootpath)
    if not dir_list:
        
        return ''
    
    for cur_file in dir_list:
        fullpath = rootpath+'/'+cur_file
        fullpath=fullpath.replace('\\','/')

        if os.path.isfile(fullpath)==1:
            #print(fullpath)
            if cur_file==thename:
                return fullpath
        else:
            #print(fullpath)
            v= getfile_fullpath(thename,fullpath)
            if v!='':
                return v
    return ''

            


def create_dict_by_path(root_dict,path):
    path=path.replace('\\','/')
    dir_list=os.listdir(path)
    if not dir_list:
        return
    
    for cur_file in dir_list:
        fullpath = path+'/'+cur_file
        fullpath=fullpath.replace('\\','/')

        if os.path.isfile(fullpath)==1:
            if fullpath.endswith('.txt'):
                add_treelist_data(root_dict,fullpath,1)
        else:
            sublist=os.listdir(fullpath)
            if not sublist or len(sublist)==0:
                continue
            create_dict_by_path(root_dict,fullpath)


def create_dict_by_path_main(path):
    root_dict={'label':'root','children':[],'type':0,'path':''}
    create_dict_by_path(root_dict,path)
    return root_dict
    

@app.route("/api/get_script_list", methods=["POST"])
def get_script_list():

    token = request.headers.get("token")
    if token != "111":
        return ret_token_ng() 
       
    path=request.json['path']
    CLOG('GET LIST =%s\n'%(path))

    root_dict=create_dict_by_path_main(current_dir+'/files')

 
    return ret_json(code='0',path=path,data=root_dict['children'])

@app.route("/api/get_script_file", methods=["POST"])
def get_script_file():
    
    token = request.headers.get("token")
    if token != "111":
        return ret_token_ng() 
       
    path=request.json['path']
    CLOG('GET FILE =%s\n'%(path))

    thefile=path

    if not os.path.isfile(thefile):
        thefile=getfile_fullpath(thefile)
        if not os.path.isfile(thefile):
            return ret_json(code='1',path=path,data='')
        
   
    try:
        with open(thefile,encoding='utf-8') as f:
            data=f.read()
    except:
        pass

    return ret_json(code='0',path=thefile,data=data,help='')



@app.route("/api/save_script_file", methods=["POST"])
def save_script_file():
    token = request.headers.get("token")
    if token != "111":
        return ret_token_ng() 
       
    path=request.json['path']
    data=request.json['data']
    CLOG('SAVE FILE =%s\n'%(path))
  
  
    if path=='':
        return ret_json(code='1',path=path,data='',help='ERROR')
    
    if not os.path.isfile(path):
        if not path.endswith('.txt'):
            path+='.txt'

        if ':' in path:
            pass
        else:
            path=current_dir+'/files/'+path
        with open(path,'w+',newline = "\n",encoding='utf-8') as f:
            f.write(data)
    else:

        with open(path,'w',newline = "\n",encoding='utf-8') as f:
            f.write(data)

    return ret_json(code='0',path=path)

def ret_token_ng():
    return  ret_json(code=1,msg='token不存在或已过期')


def ret_json(**kwargs):
    return jsonify(kwargs)


@app.route("/api/localopen", methods=["POST"])
def localopen():
    
    token = request.headers.get("token")

    if token != "111":
        return ret_token_ng()
        
    cmd=request.json['cmd']
    data=request.json['data']
    if cmd =='vscode_open_folder':
        cmd='%s %s'%('code',current_dir+'/files')
  
    os.system(cmd)

    return ret_json(code='0',state='OK')



def CLOG(text):
    thedate=time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()) 
    print('%s %s'%(thedate,text))




def http_service_function():
    app.run(host="0.0.0.0",port=9999,debug=False)
    


def start_web(url):

    print('浏览 %s\n'%url)
    os.system('explorer \"%s\"'%url)
    http_service_function()
 


def main():
 
    print('WebPage...')

    server_port='9999'
      
    start_web('http://localhost:'+server_port)
    



if __name__ == '__main__':


    main()
